/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.IAmmoProvider;
import dev.toma.gunsrpg.api.common.data.IProgressData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.setup.MaterialContainer;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_SelectAmmoPacket;
import dev.toma.gunsrpg.util.Lifecycle;
import dev.toma.gunsrpg.util.RenderUtils;
import dev.toma.gunsrpg.util.locate.ammo.ItemLocator;
import dev.toma.gunsrpg.util.math.IDimensions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ChooseAmmoScreen
extends Screen {
    private final IAmmoProvider[] items;

    public ChooseAmmoScreen(GunItem item) {
        super((ITextComponent)new TranslationTextComponent("screen.ammo_select"));
        Lifecycle lifecycle = GunsRPG.getModLifecycle();
        this.items = lifecycle.getAllCompatibleAmmoProviders(item);
    }

    protected void func_231160_c_() {
        double diff = 1.0 / (double)this.items.length;
        int x = this.field_230708_k_ / 2;
        int y = this.field_230709_l_ / 2;
        double horizontalScale = (float)x / 2.4f;
        double verticalScale = (float)y / 1.5f;
        IDimensions dimensions = IDimensions.of(this.field_230708_k_, this.field_230709_l_);
        for (int i = 0; i < this.items.length; ++i) {
            double angle = Math.toRadians((double)i * diff * 360.0);
            double sin = Math.sin(angle);
            double cos = Math.cos(Math.PI - angle);
            int btnX = (int)(sin * horizontalScale) - 16;
            int btnY = (int)(cos * verticalScale) - 16;
            this.func_230480_a_(new AmmoButton(x + btnX, y + btnY, this.items[i], dimensions));
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderUtils.drawSolid(matrix.func_227866_c_().func_227870_a_(), 0, 0, this.field_230708_k_, this.field_230709_l_, 0x66000000);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        this.field_230706_i_.func_147108_a(null);
        return true;
    }

    private static class AmmoButton
    extends Widget {
        private final IDimensions parentDimensions;
        private final IAmmoProvider ammo;
        private final int count;
        private int requiredLevel;
        private ItemStack stack;

        public AmmoButton(int x, int y, IAmmoProvider ammo, IDimensions parentDimensions) {
            super(x, y, 32, 32, StringTextComponent.field_240750_d_);
            this.ammo = ammo;
            this.parentDimensions = parentDimensions;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            ItemStack stack = player.func_184614_ca();
            boolean isGun = stack.func_77973_b() instanceof GunItem;
            this.count = ItemLocator.sum((IInventory)player.field_71071_by, ItemLocator.filterByAmmoTypeAndMaterial(ammo));
            this.field_230693_o_ = false;
            this.stack = new ItemStack((IItemProvider)((Item)ammo));
            PlayerData.get((PlayerEntity)player).ifPresent(data -> {
                IProgressData genericData = data.getProgressData();
                ISkillProvider provider = data.getSkillProvider();
                if (isGun) {
                    GunItem gun = (GunItem)stack.func_77973_b();
                    MaterialContainer container = gun.getContainer();
                    int weaponLevel = genericData.getWeaponStats(gun).getLevel();
                    this.requiredLevel = container.getRequiredLevel(ammo.getMaterial());
                    this.field_230693_o_ = provider.hasSkill(gun.getRequiredSkill()) && weaponLevel >= this.requiredLevel;
                }
            });
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer font = mc.field_71466_p;
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
            RenderUtils.drawGradient(pose, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, -16777216, -16777216);
            if (this.field_230693_o_) {
                RenderUtils.drawGradient(pose, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230690_l_ + this.field_230688_j_ - 1, this.field_230691_m_ + this.field_230689_k_ - 1, -14505438, -16742400);
            } else {
                RenderUtils.drawGradient(pose, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230690_l_ + this.field_230688_j_ - 1, this.field_230691_m_ + this.field_230689_k_ - 1, -12303292, -13421773);
            }
            mc.func_175599_af().func_175042_a(this.stack, this.field_230690_l_ + 8, this.field_230691_m_ + 8);
            int countWidth = font.func_78256_a(String.valueOf(this.count)) / 2;
            IAmmoMaterial material = this.ammo.getMaterial();
            ITextComponent name = material.getDisplayName();
            int nameWidth = font.func_238414_a_((ITextProperties)name) / 2;
            font.func_243246_a(matrix, name, (float)(this.field_230690_l_ + 16 - nameWidth), (float)(this.field_230691_m_ + this.field_230689_k_ + 1), material.getTextColor());
            font.func_238405_a_(matrix, this.count + "", (float)(this.field_230690_l_ + 25 - countWidth), (float)(this.field_230691_m_ + this.field_230689_k_ - 11), 0xFFFFFF);
            if (this.field_230692_n_ && !this.field_230693_o_) {
                String text = String.format("\u9700\u8981\u6b66\u5668\u7b49\u7ea7\u8fbe\u5230 %d", this.requiredLevel);
                int textWidth = font.func_78256_a(text);
                int centerX = this.parentDimensions.getWidth() / 2 - textWidth / 2;
                int n = this.parentDimensions.getHeight() / 2;
                font.getClass();
                int centerY = n - 9 / 2;
                font.func_238405_a_(matrix, text, (float)centerX, (float)centerY, 0xDD0000);
            }
        }

        public boolean func_231047_b_(double mouseX, double mouseY) {
            return mouseX >= (double)this.field_230690_l_ && mouseX <= (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY >= (double)this.field_230691_m_ && mouseY <= (double)(this.field_230691_m_ + this.field_230689_k_);
        }

        public void func_230982_a_(double p_230982_1_, double p_230982_3_) {
            NetworkManager.sendServerPacket(new C2S_SelectAmmoPacket(this.ammo.getMaterial()));
        }
    }
}

